/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.IValidationHandler;
import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.adapter.TypeAdapters;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ObjectValue;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ConfigHolder<CFG> {
    private static final Map<String, ConfigHolder<?>> REGISTERED_CONFIGS = new HashMap();
    private final String configId;
    private final String filename;
    private final String group;
    private final CFG configInstance;
    private final Class<CFG> configClass;
    private final IConfigFormatHandler format;
    private final Map<String, ConfigValue<?>> valueMap = new LinkedHashMap();
    private final Map<String, ConfigValue<?>> networkSerializedFields = new HashMap();
    private final Set<IFileRefreshListener<CFG>> fileRefreshListeners = new HashSet<IFileRefreshListener<CFG>>();
    private final Object lock = new Object();

    public ConfigHolder(Class<CFG> cfgClass, String configId, String filename, String group, IConfigFormatHandler format) {
        this.configClass = cfgClass;
        this.configId = configId;
        this.filename = filename;
        this.group = group;
        try {
            this.configInstance = cfgClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Configuration.LOGGER.fatal(Configuration.MAIN_MARKER, "Failed to instantiate config class for {} config", (Object)configId);
            throw new RuntimeException("Config create failed", e);
        }
        try {
            this.serializeType(this.configClass, this.configInstance, true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Config serialize failed", e);
        }
        this.format = format;
        this.loadNetworkFields(this.valueMap, this.networkSerializedFields);
    }

    public static void registerConfig(ConfigHolder<?> holder) {
        REGISTERED_CONFIGS.put(holder.configId, holder);
        ConfigIO.processConfig(holder);
    }

    public static <CFG> Optional<ConfigHolder<CFG>> getConfig(String id) {
        ConfigHolder<?> value = REGISTERED_CONFIGS.get(id);
        return value == null ? Optional.empty() : Optional.of(value);
    }

    public static Map<String, List<ConfigHolder<?>>> getConfigGroupingByGroup() {
        return REGISTERED_CONFIGS.values().stream().collect(Collectors.groupingBy(ConfigHolder::getGroup));
    }

    public static List<ConfigHolder<?>> getConfigsByGroup(String group) {
        return REGISTERED_CONFIGS.values().stream().filter(configHolder -> configHolder.group.equals(group)).collect(Collectors.toList());
    }

    public static Set<String> getSynchronizedConfigs() {
        return REGISTERED_CONFIGS.entrySet().stream().filter(e -> ((ConfigHolder)e.getValue()).networkSerializedFields.size() > 0).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void addFileRefreshListener(IFileRefreshListener<CFG> listener) {
        this.fileRefreshListeners.add(Objects.requireNonNull(listener));
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getGroup() {
        return this.group;
    }

    public CFG getConfigInstance() {
        return this.configInstance;
    }

    public Class<CFG> getConfigClass() {
        return this.configClass;
    }

    public IConfigFormatHandler getFormat() {
        return this.format;
    }

    public Collection<ConfigValue<?>> values() {
        return this.valueMap.values();
    }

    public Map<String, ConfigValue<?>> getValueMap() {
        return this.valueMap;
    }

    public Map<String, ConfigValue<?>> getNetworkSerializedFields() {
        return this.networkSerializedFields;
    }

    public void dispatchFileRefreshEvent() {
        this.fileRefreshListeners.forEach(listener -> listener.onFileRefresh(this));
    }

    public Object getLock() {
        return this.lock;
    }

    private Map<String, ConfigValue<?>> serializeType(final Class<?> type, final Object instance, boolean saveValue) throws IllegalAccessException {
        Field[] fields;
        LinkedHashMap map = new LinkedHashMap();
        for (final Field field : fields = type.getFields()) {
            Configurable value = field.getAnnotation(Configurable.class);
            if (value == null) continue;
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
                Configuration.LOGGER.warn(ConfigIO.MARKER, "Skipping config field {}, only instance non-final types are supported", (Object)field);
                continue;
            }
            final TypeAdapter adapter = TypeAdapters.forType(field.getType());
            if (adapter == null) {
                Configuration.LOGGER.warn(ConfigIO.MARKER, "Missing adapter for type {}, skipping serialization", field.getType());
                continue;
            }
            String[] comments = new String[]{};
            Configurable.Comment comment = field.getAnnotation(Configurable.Comment.class);
            if (comment != null) {
                comments = comment.value();
            }
            field.setAccessible(true);
            ConfigValue<?> cfgValue = adapter.serialize(field.getName(), comments, field.get(instance), (type1, instance1) -> this.serializeType(type1, instance1, false), new TypeAdapter.AdapterContext(){

                @Override
                public TypeAdapter getAdapter() {
                    return adapter;
                }

                @Override
                public Field getOwner() {
                    return field;
                }

                @Override
                public void setFieldValue(Object value) {
                    field.setAccessible(true);
                    try {
                        adapter.setFieldValue(field, instance, value);
                    }
                    catch (IllegalAccessException e) {
                        Configuration.LOGGER.error(ConfigIO.MARKER, "Failed to update config value for field {} from {} to a new value {} due to error {}", (Object)field.getName(), (Object)type, value, (Object)e);
                    }
                }
            });
            Configurable.ValueUpdateCallback callback = field.getAnnotation(Configurable.ValueUpdateCallback.class);
            if (callback != null) {
                this.processCallback(callback, type, instance, cfgValue);
            }
            cfgValue.processFieldData(field);
            map.put(field.getName(), cfgValue);
            if (!saveValue) continue;
            this.assignValue(cfgValue);
        }
        return map;
    }

    private <T> void processCallback(Configurable.ValueUpdateCallback callback, Class<?> type, Object instance, ConfigValue<T> value) {
        String methodName = callback.method();
        try {
            Class<Object> valueType = value.getValueType();
            if (callback.allowPrimitivesMapping()) {
                valueType = ConfigUtils.remapPrimitiveType(valueType);
            }
            Method method = type.getDeclaredMethod(methodName, valueType, IValidationHandler.class);
            ConfigValue.SetValueCallback<Object> setValueCallback = (val, handler) -> {
                try {
                    method.setAccessible(true);
                    method.invoke(instance, val, handler);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Configuration.LOGGER.error(ConfigIO.MARKER, "Error occurred while invoking {} method: {}", (Object)method, (Object)e);
                }
            };
            value.setValueValidator(setValueCallback);
            Configuration.LOGGER.debug(ConfigIO.MARKER, "Attached new value listener method '{}' for config value {}", (Object)methodName, (Object)value.getId());
        }
        catch (NoSuchMethodException e) {
            Configuration.LOGGER.error(ConfigIO.MARKER, "Unable to map method {} for config value {} due to {}", (Object)methodName, (Object)value.getId(), (Object)e);
        }
        catch (Exception e) {
            Configuration.LOGGER.fatal(ConfigIO.MARKER, "Fatal error occurred while trying to map value listener for {} method", (Object)methodName);
            throw new RuntimeException("Value listener map failed", e);
        }
    }

    private <T> void assignValue(ConfigValue<T> value) {
        this.valueMap.put(value.getId(), value);
    }

    private void loadNetworkFields(Map<String, ConfigValue<?>> src, Map<String, ConfigValue<?>> dest) {
        src.values().forEach(value -> {
            if (value instanceof ObjectValue) {
                Map data = (Map)((ObjectValue)value).get();
                this.loadNetworkFields(data, dest);
            } else {
                if (!value.shouldSynchronize()) {
                    return;
                }
                String path = value.getFieldPath();
                dest.put(path, (ConfigValue<?>)value);
            }
        });
    }

    @FunctionalInterface
    public static interface IFileRefreshListener<CFG> {
        public void onFileRefresh(ConfigHolder<CFG> var1);
    }
}

